<?php
namespace App\Libraries;

use App\Models\SettingsModel;

class Settings
{
    private $settings;

    /**
     * Create models, config and library's
     */
    function __construct()
    {
        $this->settings = new SettingsModel();
    }

    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get settings value by key
     * @param string $key
     * @return null|string
     */
    public function get_config(string $key): ?string
    {
        $config = $this->settings
            ->where("set_key", esc($key))
            ->first();
        return !$config ? null : $config["value"];
    }

    /**
     * Set last check installation date
     * @param string $date
     * @return bool True if successful, false otherwise
     */
    public function set_last_check_installation_date(string $date): bool
    {
        return $this->set_config('last_check_installation_date', $date);
    }

    /**************************************************************************************
     * PRIVATE FUNCTIONS
     **************************************************************************************/

    /**
     * Set value in settings database
     * @param string $key Setting key
     * @param string $value Setting value
     * @return bool True if successful, false otherwise
     */
    private function set_config(string $key, string $value): bool
    {
        try {
            $id = esc($key);
            $existing = $this->settings->where("set_key", $id)->first();
            
            if ($existing) {
                return $this->settings->update($id, [
                    'value' => $value
                ]);
            }

            return $this->settings->insert([
                'set_key' => $id,
                'value' => $value
            ]) ? true : false;
        } catch (\Exception $e) {
            return false;
        }
    }
}