<?php namespace App\Controllers\Api\Manager\PlansExtra;

use App\Controllers\PrivateController;
use App\Models\PlansExtraModel;
use CodeIgniter\HTTP\ResponseInterface;

class PlansExtraList extends PrivateController
{
  	/**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get plans_extra list
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $plansExtra = new PlansExtraModel();
        $items = $plansExtra
          	->where("deleted_at", 0)
          	->orderBy("build_count_extra", "ASC")
          	->findAll();

        $list = [];
        foreach ($items as $item) {
            $list[] = [
                "id"                => (int) $item["id"],
                "build_count_extra" => (int) $item["build_count_extra"],
                "price"             => $item["price"],
                "save"              => $item["save"],
                "api_id"            => $item["api_id"],
                "status"            => (int) $item["status"]
            ];
        }

        return $this->respond(["list" => $list], 200);
    }
}