<?php declare(strict_types=1);

return [
    'and' => '并且',
    'or'  => '或者',

    'rule.default'                  => ':attribute 不可用',
    'rule.accepted'                 => ':attribute 必须是其中之一: :accepted',
    'rule.after'                    => ':attribute 必须晚于时间 :time',
    'rule.alpha'                    => ':attribute 只能是字母符号',
    'rule.alpha_dash'               => ':attribute 只允许以下内容： a-z, 0-9, _ 和 -',
    'rule.alpha_num'                => ':attribute 只能是字母或者数字',
    'rule.alpha_spaces'             => ':attribute 只能包含字母或者空格',
    'rule.any_of'                   => ':attribute 中的每个字符必须是其中之一：:allowed_values',
    'rule.array'                    => ':attribute 必须是数组',
    'rule.array_must_have_keys'     => ':attribute 必须包含如下所有键名： :keys',
    'rule.array_can_only_have_keys' => ':attribute 必须只能存在如下键名： :keys',
    'rule.before'                   => ':attribute 必须早于时间 :time.',
    'rule.between'                  => ':attribute 必须处于范围 :min 到 :max 之间',
    'rule.boolean'                  => ':attribute 必须是布尔值',
    'rule.date'                     => ':attribute 不是合法的日期格式',
    'rule.default_value'            => ':attribute 默认值为： :default',
    'rule.different'                => ':attribute 必须和字段 :field 值不同',
    'rule.digits'                   => ':attribute 必须是数字且长度必须是：:length',
    'rule.digits_between'           => ':attribute 必须是数字且长度必须在范围 :min 至 :max 以内',
    'rule.email'                    => ':attribute 不是合法的邮箱地址',
    'rule.ends_with'                => ':attribute 必须以 :compare_with 结尾',
    'rule.exists'                   => ':attribute 必须匹配一个存在的记录',
    'rule.extension'                => ':attribute 必须是一个如下格式的文件：:allowed_extensions',
    'rule.float'                    => ':attribute 必须是一个浮点数',
    'rule.in'                       => ':attribute 必须是以下列表中的值： :allowed_values',
    'rule.integer'                  => ':attribute 必须是整数',
    'rule.ip'                       => ':attribute 必须是合法的 IP 地址',
    'rule.ipv4'                     => ':attribute 必须是合法的 IPv4 地址',
    'rule.ipv6'                     => ':attribute 必须是合法的 IPv6 地址',
    'rule.json'                     => ':attribute 必须是合法的 JSON 字符串',
    'rule.length'                   => ':attribute 必须是长度为： :length 的字符串',
    'rule.lowercase'                => ':attribute 必须是小写字母格式',
    'rule.max'                      => ':attribute 最大值为： :max',
    'rule.mimes'                    => ':attribute 文件类型必须是： :allowed_types',
    'rule.min'                      => ':attribute 最小值为 :min',
    'rule.not_in'                   => ':attribute 不能是以下列表中的值： :disallowed_values',
    'rule.numeric'                  => ':attribute 必须是数字类型',
    'rule.phone_number'             => ':attribute 不是合法的 E.164 格式的电话号码',
    'rule.present'                  => ':attribute 不存在',
    'rule.prohibited'               => ':attribute 禁止使用',
    'rule.prohibited_if'            => '如果 :field 字段存在以下值：:values，:attribute 禁止使用',
    'rule.prohibited_unless'        => '如果 :field 字段不存在以下值：:values，:attribute 禁止使用',
    'rule.regex'                    => ':attribute 格式不正确',
    'rule.rejected'                 => ':attribute 必须是以下值: :rejected',
    'rule.required'                 => ':attribute 必须存在',
    'rule.requires'                 => ':attribute 同时需要传递字段 :fields',
    'rule.required_if'              => '如果 :field 字段存在以下值：:values，:attribute 必须存在',
    'rule.required_unless'          => '如果 :field 字段存在以下值其中之一：:values，:attribute 必须存在',
    'rule.required_with'            => ':attribute 必须和字段 :fields 同时存在',
    'rule.required_with_all'        => ':attribute 必须和以下全部字段都同时存在： :fields',
    'rule.required_without'         => '当 :fields 为空时，:attribute 必须存在',
    'rule.required_without_all'     => '当以下字段全部为空时： :fields，:attribute 必须存在',
    'rule.same'                     => ':attribute 必须和字段 :field 值相同',
    'rule.starts_with'              => ':attribute 必须以 :compare_with 开头',
    'rule.string'                   => ':attribute 必须是字符串',
    'rule.unique'                   => ':attribute 必须是唯一值, :value 已经存在',
    'rule.uploaded_file'            => ':attribute 不是合法的上传文件',
    'rule.uploaded_file.min_size'   => ':attribute 文件大小过小, 允许的最小值为： :min_size',
    'rule.uploaded_file.max_size'   => ':attribute 文件太大, 最大允许值为： :max_size',
    'rule.uploaded_file.type'       => ':attribute 文件类型必须是： :allowed_types',
    'rule.uppercase'                => ':attribute 必须是大写字母格式',
    'rule.url'                      => ':attribute 不是合法的 URL',
    'rule.uuid'                     => ':attribute 不是合法的 UUID 或者是 NIL 格式',
];
